/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.*;
import junit.framework.*;
import java.util.*;

public class DomainObjectFactoryTest extends DomainTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/domain/DomainObjectFactoryTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public DomainObjectFactoryTest(String name) {
        super(name);
    }

    protected void domainTearDown() {
        // Return to original state.
        DomainObjectFactory.resetFactory();
        super.domainTearDown();
    }

    public void testNewInstance() throws Exception {

        DataObject object = getSession().create("com.arsdigita.kernel.User");
        try {
            DomainObjectFactory.newInstance(object);
            fail("Shouldn't be able to make a newInstance for " + object.getObjectType());
        }
        catch(RuntimeException e) {
        }

        DomainObjectFactory.registerInstantiator( object.getObjectType(),
                                                  makeDefaultInstantiator() );
        DomainObject o = DomainObjectFactory.newInstance(object);
        assertNotNull("Should have made a domain object!!!", o);

    }


    /**
     * Tests fix for bz 98292
     */
    public void testNullDataOjbect() {
        DomainObject result = DomainObjectFactory.newInstance((DataObject) null);
        assertNull(result);
    }

    public void testRegisterInstantiator() {
        DomainObjectInstantiator prev;
        DomainObjectInstantiator first = makeDefaultInstantiator();

        prev = DomainObjectFactory.registerInstantiator( "com.arsdigita.kernel.User",
                                                         first );
        assertNull("Should be no previous instantiator!", prev);
        DataObject object = getSession().create("com.arsdigita.kernel.User");
        prev = DomainObjectFactory.registerInstantiator( object.getObjectType(),
                                                         makeDefaultInstantiator() );

        assertEquals( "Didn't get back original instantiator!", first, prev);


    }

    public void testGetInstantiator() {
        DomainObjectInstantiator inst;
        inst = DomainObjectFactory.getInstantiator( "com.arsdigita.kernel.User" );
        assertNull( "There should be no instantiators!", inst );

        DomainObjectInstantiator userInst = makeDefaultInstantiator();
        DomainObjectFactory.registerInstantiator( "com.arsdigita.kernel.User",
                                                  userInst );
        inst = DomainObjectFactory.getInstantiator( "com.arsdigita.kernel.User" );
        assertEquals( "Didn't get back user instantiator!", userInst, inst);

        DataObject object = getSession().create("com.arsdigita.kernel.Party");
        DomainObjectInstantiator partyInst = makeDefaultInstantiator();
        DomainObjectFactory.registerInstantiator( object.getObjectType(),
                                                  partyInst);

        inst = DomainObjectFactory.getInstantiator( object.getObjectType() );
        assertEquals( "Didn't get back party instantiator!", partyInst, inst);


    }

    DomainObjectInstantiator makeDefaultInstantiator() {
        return new DomainObjectInstantiator()  {
                protected DomainObject doNewInstance(DataObject dataObject)  {
                    return new DomainObject(dataObject) {

                        };
                }
            };
    }


}
