/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.bebop.*;

public class NumberValidationListenerTest
    extends ValidationListenerTest {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/NumberValidationListenerTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */

    public NumberValidationListenerTest(String id) {
        super(id);
    }

    public void testNumberInRangeNoValues() {

        long high = 20;
        long low = -20;
        String[] specifiedValues = {};

        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        _validationListener=new NumberInRangeValidationListener(low,high);
        _numberParameter.addParameterListener(_validationListener);
        createFormData();
        ParameterData data = _formData.getParameter("NumberParameter");
        try {
            data.validate();
            assertTrue(data.isValid());
        } catch (FormProcessException e) {
            fail(e.getMessage());
        }
    }

    public void testNumberInRangeOneGood() {

        long high = 20;
        long low = -20;
        String[] specifiedValues = {"10"};

        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        _validationListener=new NumberInRangeValidationListener(low,high);
        _numberParameter.addParameterListener(_validationListener);
        createFormData();
        ParameterData data = _formData.getParameter("NumberParameter");
        try {
            data.validate();
            assertTrue(data.isValid());
        } catch (FormProcessException e) {
            fail(e.getMessage());
        }
    }

    public void testNumberInRangeOneBad() {

        long high = 20;
        long low = -20;
        String[] specifiedValues = {"-25"};

        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        _validationListener=new NumberInRangeValidationListener(low,high);
        _numberParameter.addParameterListener(_validationListener);
        createFormData();
        ParameterData data = _formData.getParameter("NumberParameter");
        try {
            data.validate();
            assertTrue(!data.isValid());
        } catch (FormProcessException e) {
            fail(e.getMessage());
        }

    }
}
