/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;

import java.lang.IllegalArgumentException;
import java.math.BigDecimal;

public class BigDecimalParameterTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/BigDecimalParameterTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */
    protected ParameterModel _stringParameter;
    protected ParameterModel _numberParameter;
    protected HttpServletDummyRequest _httpRequest;

    public BigDecimalParameterTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */

    protected void setUp() {
        _stringParameter =  new StringParameter("StringParameter");
        _numberParameter =  new BigDecimalParameter("NumberParameter");
        _httpRequest = new HttpServletDummyRequest();

    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */

    protected void tearDown() {

        _stringParameter=null;
        _numberParameter=null;
        _httpRequest=null;

    }
    public void testNumberParameterNoValues() {

        String[] specifiedValues = {};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest), null);

    }

    public void testNumberParameterEmptyValue() {

        String[] specifiedValues = {""};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest), null);
    }

    public void testNumberParameterBadValue() {

        String[] specifiedValues = {"Not a Number"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        try {
            Integer temp = (Integer)_numberParameter.transformValue(_httpRequest);
            // if you get here an exception was not raised
            fail();
        } catch (IllegalArgumentException iae) {
            // ok.
        }
    }

    public void testNumberParameterGoodIntegerValue() {
        String[] specifiedValues = {"5"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),new BigDecimal("5"));
    }

    public void testNumberParameterGoodFloatValue() {
        String[] specifiedValues = {"5.01"};
        _httpRequest.setParameterValues("NumberParameter",specifiedValues );
        assertEquals(_numberParameter.transformValue(_httpRequest),new BigDecimal("5.01"));
    }
}
