/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import org.apache.log4j.Logger;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;

/**
 * Regression tests for the ToggleLink component.
 *
 * @version $Revision: #11 $ $Date: 2004/04/07 $
 */

public class ToggleLinkTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/ToggleLinkTest.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log =
        Logger.getLogger(ToggleLinkTest.class);

    public ToggleLinkTest (String id) throws Exception {
        super(id);
    }

    /**
     *  Test a ToggleLink
     */
    public void testStringToggleLink() {
        testComponent(new ToggleLink("toggley toggle"),"string");
    }

    /**
     *  Test a Componentized ToggleLink
     */
    public void testComponentizedToggleLink() {
        Label toggleLabel = new Label("Toggles");
        ToggleLink toggleMe = new ToggleLink(toggleLabel);
        testComponent(toggleMe,"component");
    }

    /**
     * Test getSelectedComponent()
     */
    public void testGetSelectedComponent() {
        PageState m_pageState = getPageState();

        Label toggleLabel = new Label("Toggles");
        ToggleLink toggleMe = new ToggleLink(toggleLabel);
        Label returnedLabel = (Label) toggleMe.getSelectedComponent();

        String expected = "Toggles";
        String actual = returnedLabel.getLabel(m_pageState);

        assertEquals(expected,actual);
    }

    /**
     * Test setSelectedComponent()
     */
    public void testSetSelectedComponent() {

        PageState m_pageState = getPageState();
        Label toggleLabel = new Label("Toggles");
        Label fakeLabel = new Label("no toggles");
        ToggleLink tl = new ToggleLink(fakeLabel);
        tl.setSelectedComponent(toggleLabel);

        // We don't use testComponent here because the
        // setSelectedComponent method doesn't make the component
        // selected, while the constructor does make the component
        // selected.
        Label returnedLabel = (Label) tl.getSelectedComponent();
        String expected = "Toggles";
        String actual = returnedLabel.getLabel(m_pageState);
        assertEquals(expected,actual);

    }

    private PageState getPageState () {
        Page p = new Page();
        p.lock();
        ComponentTestHarness harness = new ComponentTestHarness(p);
        return harness.getPageState();
    }

}
