/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


/**
 * Regression tests for the TabbedPanel component.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class TabbedPaneTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/TabbedPaneTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public TabbedPaneTest(String id) {
        super(id);
    }

    /**
     *  Test a TabbedPane with a Label.
     */
    public void testTabbedPane() {
        Label mylabel = new Label("This is a Label");
        TabbedPane tp = new TabbedPane();
        tp.addTab("Tab A", mylabel);
        testComponent(tp,"one-label");
    }

    /**
     *
     * Test a TabbedPane. Make sure that the contents of the first tab
     * are fully visible on the first request.
     *
     */
    public void testTabbedPaneVisible() {
        Label labelA = new Label("first tab");
        Label labelB = new Label("second tab");
        TabbedPane tp = new TabbedPane();

        tp.add(labelA);
        tp.addTab("tab2",labelB);
        testComponent(tp,"first-visible");
    }


    /**
     * Test an empty TabbedPane.  */
    //      public void testEmptyTabbedPane() {
    //          testComponent(new TabbedPane(), "empty");
    //      }

}
