/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

/**
 * Regression tests for the SimpleComponent.
 *
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */

public class SimpleComponentTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/SimpleComponentTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public SimpleComponentTest (String id) {
        super(id);
    }

    /**
     *  Test custom name mangling.  While this tests functionality
     *  that's in SimpleComponent, it takes a stateful component to
     *  exhibit the behavior.  We pick a TabbedPane for this.  */
    public void FAILStestCustomMangling()
    {
        final String TEST_KEY = "rumpelstilzchen"; // an unlikely string
        TabbedPane pane = new TabbedPane();
        pane.setKey(TEST_KEY);          // we'll be looking for this.
        pane.addTab("either", new Label("Tab A"));
        pane.addTab("or"    , new Label("Tab B"));

        // no debugging => no structure, which would contain the key
        regexpComponent(pane, TEST_KEY, false);
    }

    /** make JTest happy: while it ignores testCustomMangling, it will
        still find this test.  A suite must have one test at least. */
    public void testSucceed(){}
}
