/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


/**
 * Regression tests for the Label component.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class LabelTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/LabelTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public LabelTest (String id) {
        super(id);
    }

    /**
     *  Test a Label with text "TestLabel"
     */
    public void testLabelWithText() {
        testComponent(new Label("TestLabel"),"testlabel");
    }

    /**
     *  Test a Label with no text
     */
    public void testEmptyLabel() {
        testComponent(new Label(),"empty");
    }

    /**
     *  Test a Label with text "TestLabel" and escaping
     */
    public void testLabelWithEscape() {
        testComponent(new Label("TestLabel",true),"escape");
    }

    /**
     *  Test a Label with text "TestLabel" and escaping, using method
     */
    public void testLabelWithEscapeMethod() {
        Label testLabel = new Label("TestLabel");
        testLabel.setOutputEscaping(true);
        testComponent(testLabel,"escape");
    }

    /**
     *  Test a Label's setFontWeight and setLabel method.
     */
    public void testLabelFWsetLabel() {
        Label testLabel = new Label("TestLabel");
        testLabel.setFontWeight("50");
        testLabel.setLabel("The New Label");
        testComponent(testLabel,"fw-setLabel");
    }

    /**
     *  Test a Label's setFontWeight. Compare the setLabel with
     *  setting the Label in the constructor.
     */
    public void testLabelFW() {
        Label testLabel = new Label("The New Label");
        testLabel.setFontWeight("50");
        testComponent(testLabel,"fw-setLabel");
    }

}
