/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.PermissionDecorator;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Kernel;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.extensions.TestDecorator;

/**
 * AuditingSuite
 *
 *
 * @author Joseph A. Bank (jbank@alum.mit.edu)
 * @version 1.0
 **/
public class AuditingSuite extends PackageTestSuite {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/auditing/AuditingSuite.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public AuditingSuite() {
        super();
    }

    public AuditingSuite(Class theClass) {
        super(theClass);
    }

    public AuditingSuite(String name) {
        super(name);
    }

    public void addTest(Test test) {
        PermissionDecorator perm = new PermissionDecorator(test);
        super.addTest(perm);
    }

    public static Test suite() {
        AuditingSuite suite = new AuditingSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new CoreTestSetup(suite);
        return wrapper;
    }

    public static void main(String[] args) throws Exception {
        junit.textui.TestRunner.run( suite() );
    }

}
