/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;

import java.util.Iterator;
import java.util.Collections;
import java.math.BigDecimal;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;

public class WorkflowTemplate extends Workflow {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/WorkflowTemplate.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workflow.simple.WorkflowTemplate";

    /**
     * Creates a new workflow process definition.  Properties of this object
     * are not made persistent until the <code>save()</code> method is called.
     *
     * @param label the label
     * @param description the description
     *
     **/
    public WorkflowTemplate(String label, String description) {
        super(BASE_DATA_OBJECT_TYPE);
        initAttributes(label,description);
    }

    /**
     * Creates a new workflow process definition with the properties
     * <code>label</code> and <code>description</code> set to null.
     * Properties of this
     * object are not made persistent until the <code>save</code>
     * method is called. If save() is called
     * without setting these properties, an IllegalArgumentException
     * will be thrown.
     *
     **/
    public WorkflowTemplate() {
        super(BASE_DATA_OBJECT_TYPE);
    }


    /**
     * Restores a workflow process definition from task data object.
     *
     * @param workflowTemplateDataObject the template object to restore the process from
     *
     **/
    public WorkflowTemplate(DataObject workflowTemplateDataObject) {
        super(workflowTemplateDataObject);
    }

    /**
     * Constructor for setting the object type name.
     *
     * @param type the type name
     *
     **/
    protected WorkflowTemplate(ObjectType type) {
        super(type);
    }

    protected WorkflowTemplate(String typeName) {
        super(typeName);
    }

    /**
     * Restores a workflow process definition with an OID.
     *
     * @param oid the OID
     *
     **/
    public WorkflowTemplate(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    /**
     * Restores a workflow process definition with a BigDecimal.
     *
     * @param id the BigDecimal ID of this object. An OID will be
     * created implicitly with the BASE_DATA_OBJECT_TYPE constant
     * specified in this file.
     *
     **/
    public WorkflowTemplate(BigDecimal id)
        throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }
    /**
     * Creates a workflow based on the supplied workflow definition ID.
     * @return the workflow
     * */
    public Workflow instantiateNewWorkflow() {
        Workflow w = (Workflow)clone();
        if (w==null) return null;
        // save a reference to the template used to create the new Workflow
        w.setWorkflowTemplate(this);
        w.save();
        return w;
    }

    /**
     * Extends the workflow by appending the tasks from the
     * workflow template
     */
    public void extendWorkflow(Workflow workflow) {
        cloneTasks(workflow);
        startInternal();
    }

    /**
     * Adds a task to this process. (persistent operation)
     *
     * @param task the task to add to this process
     *
     * TODO: change this to use role relations. right now we just
     * change the parent of the task manually. This should be donevia
     * the PDL file.
     **/
    public void addTask(Task task) {
        task.setParent(this);
        task.save();
        //add(WF_TASKS, task);
    }
    /* We have to throw these exceptions because we decided that
       Workflow templates extend Workflows rather than that other way
       around.  */

    public void stop(User user) {

    }

    public void start(User user) {

    }

    public int getProcessState() {
        return Workflow.NONE;
    }

    public void setObject(ACSObject o) {

    }

    public Iterator getEnabledTasks() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getFinishedTasks() {
        return Collections.EMPTY_LIST.iterator();
    }
    public Iterator getOverdueTasks() {
        return Collections.EMPTY_LIST.iterator();
    }
    public OID getObjectOID() {
        return null;
    }
}
