/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import org.apache.log4j.Logger;

/**
 * Represents a collection on a task.
 *
 * @author Uday Mathur
 * @author Khy Huang
 * @version 1.0
 **/
public class TaskCollection extends DomainCollection {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/TaskCollection.java#10 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(TaskCollection.class);

    /**
     * Constructor.
     *
     * @param dataCollection the data collection
     * @see com.arsdigita.domain.DomainCollection#DomainCollection(DataCollection)
     *
     **/
    public TaskCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Internal method to get the object type information
     *
     * @return the object type
     *
     **/
    private static ObjectType getObjectType(String typeName) {
        return SessionManager.getMetadataRoot().getObjectType(typeName);
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the
     * returned domain object as a task.
     *
     * @return a task.
     **/
    public Task getTask() {
        return (Task) getDomainObject();
    }

    /**
     * Sets the order of this collection. Should be called
     * before <code>next()</code> is called on this collection.
     *
     **/
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }

    public final void childrenOf(final Task parent) {
        m_dataCollection.addEqualsFilter(Task.PARENT_TASK_ID, parent.getID());
    }
}
