/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.kernel.security.UserContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 *
 *
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/WebExposer.java#11 $
 */
public class WebExposer {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/WebExposer.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (WebExposer.class);

    public static final void clearRequestLocals() {
        InternalRequestLocal.clearAll();
    }

    public static final void initializeRequestLocals
            (final HttpServletRequest sreq) {
        InternalRequestLocal.prepareAll(sreq);
    }

    public static final void init(HttpServletRequest sreq,
                                  ServletContext sc,
                                  UserContext uc) {
        Web.init(sreq, sc, uc);
    }

    public static WebContext getInitialContext() {
        return Web.s_initialContext;
    }
}
