/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.io.BufferedReader;
import java.io.UnsupportedEncodingException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;

public class ServletRequestWrapper implements ServletRequest {
    private final ServletRequest m_req;

    public ServletRequestWrapper(ServletRequest req) {
        m_req = req;
    }

    public Object getAttribute(String name) {
        return m_req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return m_req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return m_req.getCharacterEncoding();
    }

    public int getContentLength() {
        return m_req.getContentLength();
    }

    public String getContentType() {
        return m_req.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return m_req.getInputStream();
    }

    public Locale getLocale() {
        return m_req.getLocale();
    }

    public Enumeration getLocales() {
        return m_req.getLocales();
    }

    public String getParameter(String name) {
        return m_req.getParameter(name);
    }

    public Map getParameterMap() {
        throw new UnsupportedOperationException
            ("This is a Servlet 2.3 feature that we do not currently support");
    }

    public Enumeration getParameterNames() {
        return m_req.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return m_req.getParameterValues(name);
    }

    public String getProtocol() {
        return m_req.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return m_req.getReader();
    }

    public String getRealPath(String path) {
        return m_req.getRealPath(path);
    }

    public String getRemoteAddr() {
        return m_req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return m_req.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return m_req.getRequestDispatcher(path);
    }

    public String getScheme() {
        return m_req.getScheme();
    }

    public String getServerName() {
        return m_req.getServerName();
    }

    public int getServerPort() {
        return m_req.getServerPort();
    }

    public boolean isSecure() {
        return m_req.isSecure();
    }

    public void removeAttribute(String name) {
        m_req.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        m_req.setAttribute(name, value);
    }

    public void setCharacterEncoding(String env)
            throws UnsupportedEncodingException {
        throw new UnsupportedOperationException
            ("This is a Servlet 2.3 feature that we do not currently support");
    }
}
