/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.util.Assert;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * <p>A signal that returns the client to a return URL encoded in the
 * current URL, or if the return URL is not found, uses a fallback
 * URL.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/ReturnSignal.java#7 $
 */
public class ReturnSignal extends RedirectSignal {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/ReturnSignal.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ReturnSignal.class);

    public ReturnSignal(final HttpServletRequest sreq) {
        super(getReturnURL(sreq), true);
    }

    public ReturnSignal(final HttpServletRequest sreq, final String fallback) {
        super(getReturnURL(sreq, fallback), true);
    }

    public ReturnSignal(final HttpServletRequest sreq, final URL fallback) {
        this(sreq, fallback.toString());
    }

    private static String getReturnURL(final HttpServletRequest sreq) {
        s_log.debug("Fetching the return URL to redirect to");

        final String returnURL = sreq.getParameter("return_url");

        Assert.assertNotNull(returnURL, "String returnURL");

        if (s_log.isDebugEnabled()) {
            s_log.debug("Redirecting to URL '" + returnURL + "'");
        }

        return returnURL;
    }

    private static String getReturnURL(final HttpServletRequest sreq,
                                       final String fallback) {
        s_log.debug("Fetching the return URL to redirect to");

        Assert.assertNotNull(fallback, "String fallback");

        final String returnURL = sreq.getParameter("return_url");

        if (returnURL == null  || returnURL.equals("")) {
            if (s_log.isDebugEnabled()) {
                s_log.debug("Cannot find the return URL parameter; " +
                            "using the fallback URL '" + fallback + "'");
            }

            return fallback;
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug("Redirecting to the value in the return URL " +
                            "parameter, '" + returnURL + "'");
            }

            return returnURL;
        }
    }
}
