/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigInteger;



// merged versioning

/**
 * Transaction
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/versioning/Transaction.java#23 $
 */

public class Transaction {
    public static Transaction retrieve(BigInteger id) {
        Session ssn = SessionManager.getSession();
        return new Transaction
            (ssn.retrieve(new OID(Constants.TXN_DATA_TYPE, id)));
    }

    private DataObject m_txn;
    private DataAssociation m_tags;

    Transaction(DataObject txn) {
        m_txn = txn;
        m_tags = (DataAssociation) m_txn.get(Constants.TAGS);
    }

    /**
     * @return the BigInteger ID of this transaction
     */

    public BigInteger getID() {
        return (BigInteger) m_txn.get(Constants.ID);
    }

    public TagCollection getTags() {
        return new TagCollection(m_tags.cursor());
    }

    /**
     * Get the user who created this transaction
     */
    public User getUser() {
        DataObject user = (DataObject) m_txn.get(Constants.MOD_USER);
        return (User) DomainObjectFactory.newInstance(user);
    }

    /**
     * Get the creation date of this transaction
     */
    public java.util.Date getTimestamp() {
        return (java.util.Date) m_txn.get(Constants.TIMESTAMP);
    }

    /**
     * Get the IP of the user who created this transaction
     */
    public String getIP() {
        return (String) m_txn.get(Constants.MODIFYING_IP);
    }

    /**
     * Returns a String representation of this transaction, useful for
     * debugging.
     *
     * @return a String representation of this transaction.
     */

    public String toString() {
        return m_txn.toString();
    }
}
