/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;

// new versioning

/**
 * This is a no-op adapter for the {@link RollbackListener} interface. This
 * class is provided as a convenience for easily creating rollback listeners by
 * extending this class and overriding only the methods of interest.
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since  2003-05-28
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/
class RollbackAdapter implements RollbackListener {

    public void onAdd(OID oid, String property, Object value) {}
    public void onApplyFinish() {}
    public void onApplyFinish(OID oid) {}
    public void onApplyStart() {}
    public void onApplyStart(OID oid, String state) {}
    public void onCreate(OID oid) {}
    public void onDelete(OID oid) {}
    public void onDequeue(OID oid) {}
    public void onDiffFinish() {}
    public void onDiffStart() {}
    public void onEnqueue(OID oid) {}
    public void onFinish() {}
    public void onReifyFinish() {}
    public void onReifyFinish(OID oid, String postState) {}
    public void onReifyStart() {}
    public void onReifyStart(OID oid, String preState) {}
    public void onRemove(OID oid, String property, Object value) {}
    public void onSet(OID oid, String property, Object value) {}
    public void onStart() {}
    public void onTerminalFinish() {}
    public void onTerminalStart() {}
    public void onUndoAdd(OID oid, String property, Object value) {};
    public void onUndoRemove(OID oid, String property, Object value) {};
    public void onUndoSet(OID oid, String property, Object value) {};
}
