/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;

import java.math.BigInteger;

import org.apache.log4j.Logger;

// new versioning

/**
 * A collection of changes previously made to a data object.
 *
 * @see Versions
 * @author Stanislav Freidin
 * @author Vadim Nasardinov (vadimn@redhat.com)
 */
final class ObjectChangeCollection implements Constants {
    private final static Logger s_log =
        Logger.getLogger(ObjectChangeCollection.class);

    private DataCollection m_dc;

    /**
     * @param versionedOID the oid of the versioned data object in whose change
     * history we are interested.
     * @pre versionedOID != null
     **/
    public ObjectChangeCollection(OID versionedOID, BigInteger backTo) {
        m_dc = SessionManager.getSession().retrieve(CHANGE_DATA_TYPE);
        m_dc.addFilter(OBJ_ID + " = :bindOID").
            set("bindOID", Adapter.serialize(versionedOID));

        final String sortKey = TXN + "." + ID;
        if (backTo != null) {
            m_dc.addFilter(sortKey + " > :backTo").set("backTo", backTo);
        }
        m_dc.addOrder(sortKey + " desc");
        m_dc.addOrder(ID + " desc");
    }

    public boolean next() {
        return m_dc.next();
    }

    public void close() {
        m_dc.close();
    }

    DataCollection getOperations() {
        DataAssociation da =
            (DataAssociation) m_dc.getDataObject().get(OPERATIONS);
        DataCollection result = da.cursor();
        result.addOrder(ID + " desc");
        return result;
    }
}
