/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;


// new versioning

/**
 * Used for labeling edges in the versioning dependence graph.
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2003-05-08
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/
final class EdgeLabel {
    private Property m_property;

    private final static int VERSIONED = 0;
    private final static int UNVERSIONED = 1;
    private final static int UNMARKED = -1;

    private int m_state;

    /**
     * @pre prop != null
     **/
    public EdgeLabel(Property prop) {
        Assert.exists(prop, Property.class);
        m_property = prop;
        m_state = UNMARKED;
    }

    /**
     * @post return != null
     **/
    public Property getProperty() {
        return m_property;
    }


    /**
     * @post isVersioned()
     **/
    public void setVersioned() {
        Assert.truth(m_state == UNMARKED, "is unmarked");
        m_state = VERSIONED;
    }

    public boolean isVersioned() {
        return m_state == VERSIONED;
    }

    /**
     * @post isUnversioned()
     **/
    public void setUnversioned() {
        Assert.truth(m_state == UNMARKED, "is unmarked");
        m_state = UNVERSIONED;
    }

    /**
     * Returns <code>false</code>, unless {@link #setUnversioned()} has been
     * previously called on this edge label.
     **/
    public boolean isUnversioned() {
        return m_state == UNVERSIONED;
    }

    public boolean equals(Object obj) {
        if ( obj == null ) return false;
        EdgeLabel that = (EdgeLabel) obj;
        return m_property.equals(that.m_property);
    }

    public int hashCode() {
        return m_property.hashCode();
    }
}
