/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.sitemap;


import com.arsdigita.ui.util.GlobalizationUtil ; 


import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ActionEvent;

public class SiteMapAdminPane extends SimpleContainer
    implements ActionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/sitemap/SiteMapAdminPane.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private SingleSelectionModel m_processes;
    private ToggleLink m_addLink;

    private Label m_noSelection;
    private DisplayActions m_displayActions;
    private Label m_cfgSiteMap;
    public SiteMapAdminPane (SingleSelectionModel m, ToggleLink l) {
        super();
        m_processes = m;
        m_addLink = l;

        m_noSelection = new Label(GlobalizationUtil.globalize("ui.sitemap.h4emselect_sitenode_to_view_detailsemh4"),  false);
        add(m_noSelection);

        m_displayActions = new DisplayActions(m);
        add(m_displayActions);


        //Have this call a class that outputs the config menu...
        m_cfgSiteMap = new Label(GlobalizationUtil.globalize("ui.sitemap.configuration_menu_placeholder"));
        add(m_cfgSiteMap);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(m_noSelection, true);
        p.setVisibleDefault(m_displayActions, false);
        p.setVisibleDefault(m_cfgSiteMap, false);
        p.addActionListener( this );
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        boolean proc = m_processes.isSelected(s);
        boolean add = m_addLink.isSelected(s);

        m_noSelection.setVisible(s, ! ( proc || add ));
        m_displayActions.setVisible(s, proc);
        m_cfgSiteMap.setVisible(s, add);
    }

}
