/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.login;

import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.web.Web;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.util.UncheckedWrapperException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

/**
 * An ActionListener that logs out the user.
 *
 * @author Sameer Ajmani
 **/
public class UserLogoutListener implements ActionListener {
    public static final String versionId = 
        "$Id: //core-platform/dev/src/com/arsdigita/ui/login/UserLogoutListener.java#12 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(UserLogoutListener.class);

    /**
     * Logs out the user.
     **/
    public void actionPerformed(ActionEvent event) {
        try {
            s_log.debug("Logging out user");
            UserContext uc = Web.getUserContext();
            uc.logout();
        } catch (LoginException e) {
            throw new UncheckedWrapperException("Logout failed", e);
        }
    }
}
