/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;

public class UserBanner extends SimpleComponent {

    private static GlobalizedMessage s_help;
    private static GlobalizedMessage s_signout;
    private static GlobalizedMessage s_portal;
    private static GlobalizedMessage s_greet;

    static {
        s_help = GlobalizationUtil.globalize("ui.admin.help");
        s_signout = GlobalizationUtil.globalize("ui.admin.signout");
        s_portal = GlobalizationUtil.globalize("ui.admin.portal");
        s_greet = GlobalizationUtil.globalize("ui.admin.greeting");
    }

    public void generateXML(PageState state,
                            Element parent) {
        Party party = Kernel.getContext().getParty();

        Element content = parent.newChildElement("ui:userBanner",
                                                 UIConstants.UI_XML_NS);
        exportAttributes(content);

        if (party != null && party instanceof User) {
            User user = (User)party;

            content.addAttribute("givenName", 
                                 user.getPersonName().getGivenName());
            content.addAttribute("familyName", 
                                 user.getPersonName().getFamilyName());
            content.addAttribute("screenName", 
                                 user.getScreenName());
            content.addAttribute("primaryEmail", 
                                 user.getPrimaryEmail().toString());
            content.addAttribute("userID", 
                                 user.getOID().toString());
        }

        content.addAttribute("helpLabel",
                             (String)s_help.localize(state.getRequest())); 
      
        content.addAttribute("portalLabel",
                             (String)s_portal.localize(state.getRequest())); 
      
        content.addAttribute("signoutLabel",
                             (String)s_signout.localize(state.getRequest())); 
      
        content.addAttribute("greeting",
                             (String)s_greet.localize(state.getRequest())); 
      

        content.addAttribute(
            "workspaceURL",
            URL.there(state.getRequest(),
                      Initializer.getFullURL(Initializer.WORKSPACE_PAGE_KEY,
                                             state.getRequest())).toString());

        content.addAttribute(
            "loginURL",
            URL.there(state.getRequest(),
                      Initializer.getFullURL(Initializer.LOGIN_PAGE_KEY,
                                             state.getRequest())).toString());

        content.addAttribute(
            "logoutURL",
            URL.there(state.getRequest(),
                      Initializer.getFullURL(Initializer.LOGOUT_PAGE_KEY,
                                             state.getRequest())).toString());

    }
}
