/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui;

import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import java.util.HashMap;

import com.arsdigita.util.Assert;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.SimpleComponent;


/**
 * The SimplePageLayout class stores the list of 
 * components on a page. Each component has an
 * associated layout tag which is interpreted by
 * the XSL when formatting the page. If the XSLT
 * template in question were implementing a four
 * area border layout (header, footer, left & right
 * margins), this tag might be one of the strings
 * 'top', 'bottom', 'left', 'right'. The Java code
 * places no constraints or intpretation of these
 * layout tags.
 */
class SimplePageLayout {

    private HashMap m_tags = new HashMap();

    /**
     * Adds a component to the layout with a particular
     * position tag.
     *
     * @param component A subclass of Component with a no-arg constructor
     * @param tag the layout position tag
     */
    public void addComponent(Class component,
                             String tag) {
        Assert.exists(component, Class.class);
        Assert.exists(tag, String.class);
        
        Assert.truth(SimpleComponent.class.isAssignableFrom(component),
                     "component is a subclass of SimpleComponent");
        
        List list = (List)m_tags.get(tag);
        if (list == null) {
            list = new ArrayList();
            m_tags.put(tag, list);
        }

        list.add(component);
    }
    
    /** 
     * Retrieves an iterator for all the known position tags
     * in this layout.
     * 
     * @return an iterator of position tags
     */
    public Iterator getPositionTags() {
        return m_tags.keySet().iterator();
    }
    
    /**
     * Retrieves an iterator for all components with
     * a specified tag.
     */
    public Iterator getComponents(String tag) {
        List list = (List)m_tags.get(tag);
        Assert.exists(list, List.class);
        return list.iterator();
    }
}
