/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class ProxyComponent extends ComponentMap
        implements Resettable {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ProxyComponent.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ProxyComponent.class);

    private final Component m_child;

    public ProxyComponent(final Component child) {
        m_child = child;

        put("child", child);
    }

    public boolean isVisible(final PageState state) {
        return m_child.isVisible(state);
    }

    public void generateXML(final PageState state, final Element parent) {
        m_child.generateXML(state, parent);
    }
}
