/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;

/**
 * 
 *
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ItemDetailProperty.java#9 $
 */
public class ItemDetailProperty {
    // These are protected so that subclasses can access them in
    // the generate*XML methods
    protected String m_name;
    protected String m_value;

    public ItemDetailProperty() {
        this(null, null);
    }

    public ItemDetailProperty(String name, String value) {
        m_name = name;
        m_value = value;
    }

    public void generateXML(PageState pageState, Element parent) {
        Element property = new Element("bebop:property", Component.BEBOP_XML_NS);
        parent.addContent(property);

        Element name = new Element("bebop:name", Component.BEBOP_XML_NS);
        property.addContent(name);
        generateNameXML(pageState, name);

        Element value = new Element("bebop:value", Component.BEBOP_XML_NS);
        property.addContent(value);
        generateValueXML(pageState, value);
    }


    /**
     *  This generates the XML for the Name property.  By default,
     *  it takes the passed in name and uses it as the name of the property.
     */
    public void generateNameXML(PageState pageState, Element parent) {
        parent.setText(m_name);
    }

    /**
     *  This generate the XML for the Value property.  By default
     *  it uses the passed in value.
     */
    public void generateValueXML(PageState pageState, Element parent) {
        Label l = new Label(m_value);
        l.setOutputEscaping(false);
        l.generateXML(pageState, parent);
    }
}
