/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import java.util.ArrayList;
import java.util.List;

/**
 * DomainTable
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public abstract class DomainTable extends Table {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DomainTable.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private DomainColumn m_key;
    private List m_columns = new ArrayList();
    private TableColumnModel m_columnModel;

    public DomainTable() {
        setModelBuilder(new TableModelBuilder() {
                public TableModel makeModel(Table t, PageState ps) {
                    return DomainTable.this.makeModel(ps);
                }

                public void lock() {}
                public boolean isLocked() { return true; }
            });
        m_columnModel = getColumnModel();
    }

    public void setKey(DomainColumn key) {
        m_key = key;
    }

    public TableColumn add(DomainColumn column) {
        TableColumn tc = new TableColumn(m_columns.size(),
                                         column.getName(),
                                         column.getKey());
        m_columnModel.add(tc);
        m_columns.add(column);

        tc.setCellRenderer(new DefaultTableCellRenderer(column.isActive()));
        tc.setHeaderRenderer(
                             new DefaultTableCellRenderer(column.isSortable())
                             );

        return tc;
    }

    private TableModel makeModel(final PageState ps) {
        SingleSelectionModel ss = getColumnSelectionModel();

        if (ss.isSelected(ps)) {
            int index = ((Integer) ss.getSelectedKey(ps)).intValue();
            DomainColumn dc = (DomainColumn) m_columns.get(index);
            dc.order(ps);
        }

        m_key.order(ps);

        return new TableModel() {
                public int getColumnCount() {
                    return m_columns.size();
                }

                public boolean nextRow() {
                    return DomainTable.this.next(ps);
                }

                public Object getElementAt(int index) {
                    DomainColumn dc = (DomainColumn) m_columns.get(index);
                    return dc.get(ps);
                }

                public Object getKeyAt(int index) {
                    return m_key.get(ps);
                }
            };
    }

    public abstract boolean next(PageState ps);

}
