/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.PageState;

/**
 * DomainColumn
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public abstract class DomainColumn {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DomainColumn.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_key;
    private String m_name;
    private boolean m_sortable;
    private boolean m_active;

    public DomainColumn(String key, String name) {
        this(key, name, true, false);
    }

    public DomainColumn(String key, String name, boolean sortable) {
        this(key, name, sortable, false);
    }

    public DomainColumn(String key, String name, boolean sortable,
                        boolean active) {
        m_key = key;
        m_name = name;
        m_sortable = sortable;
        m_active = active;
    }

    public String getKey() {
        return m_key;
    }

    public String getName() {
        return m_name;
    }

    public boolean isSortable() {
        return m_sortable;
    }

    public boolean isActive() {
        return m_active;
    }

    public abstract void order(PageState ps);

    public abstract Object get(PageState ps);

}
