/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ComponentSet extends SimpleComponent
        implements Resettable {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ComponentSet.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ComponentSet.class);

    private final ArrayList m_components;

    public ComponentSet() {
        m_components = new ArrayList();
    }

    public void reset(final PageState state) {
        s_log.debug("Resetting children");

        final Iterator iter = children();

        while (iter.hasNext()) {
            final Object component = iter.next();

            if (component instanceof Resettable) {
                ((Resettable) component).reset(state);
            }
        }
    }

    public final Iterator children() {
        return m_components.iterator();
    }

    public final void add(final Component component) {
        Assert.assertNotNull(component, "Component component");

        synchronized (m_components) {
            final int index = m_components.indexOf(component);

            if (index == -1) {
                m_components.add(component);
            } else {
                m_components.set(index, component);
            }
        }
    }

    public final Component get(final int index) {
        return (Component) m_components.get(index);
    }

    public final int indexOf(final Component component) {
        return m_components.indexOf(component);
    }

    public final boolean contains(final Component component) {
        return m_components.contains(component);
    }

    public void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final Iterator iter = children();

            while (iter.hasNext()) {
                ((Component) iter.next()).generateXML(state, parent);
            }
        }
    }
}
