/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.rebop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Font;


import java.util.Vector;

/**
 * GenericLabel.java
 *
 *
 * Created: Thu Sep 20 08:28:15 2001
 *
 * @author Gavin Doughtie
 * @version $Date: 2004/04/07 $
 */

public class GenericLabel extends GenericComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/GenericLabel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Dimension m_preferredSize = null;
    private boolean m_updateSize = false;

    // for button "push down" rendering
    private boolean m_useOffset = false;
    private int m_xOffset = 2;
    private int m_yOffset = 2;

    private boolean m_wrapText = true;

    private Vector m_wrappedRuns = null;

    public GenericLabel(String text) {
        setFont(new Font("SansSerif", Font.PLAIN, 12));
        updateText(text);
    }

    public GenericLabel() {
        setFont(new Font("SansSerif", Font.PLAIN, 12));
    }

    public void setFont(Font font) {
        super.setFont(font);
        StyledText stx = getStyledText();
        stx.setBaseFont(font);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        m_updateSize = true;
    }

    public void setDrawable(GenericDrawable drawable) {
        if (!(drawable instanceof StyledText)) {
            return;
        } // end of if ()
        super.setDrawable(drawable);
        StyledText stx = getStyledText();
        super.setName(stx.toString());
        m_updateSize = true;
    }

    public void addFormattedText(Font font, Color color, String string) {
        StyledText sText = getStyledText();
        sText.addRun(new FormattedText(font, color, string));
        m_updateSize = true;
    }

    private void updateText(String text) {
        super.setName(text);
        StyledText styledText = new StyledText();
        FormattedText run = new FormattedText(text);
        styledText.addRun(run);
        setDrawable(styledText);
    }

    protected StyledText getStyledText() {
        StyledText sText = (StyledText) getDrawable();
        if (null == sText) {
            if (null != getName()) {
                updateText(getName());
                sText = (StyledText) getDrawable();
            } else {
                sText = new StyledText();
                setDrawable(sText);
            }
        }
        return sText;
    }

    public void setWrappedRuns(Vector wrappedRuns) {
        m_wrappedRuns = wrappedRuns;
        if (null != m_wrappedRuns) {
            StyledText stx = getStyledText();
            stx.setWrappedRuns(m_wrappedRuns);
        }
    }

    public Vector getWrappedRuns() {
        return m_wrappedRuns;
    }

    public void setUseOffset(boolean useOffset) {
        StyledText sText = getStyledText();
        if (useOffset) {
            sText.setXOffset(sText.getXOffset() + m_xOffset);
            sText.setYOffset(sText.getYOffset() + m_yOffset);
        } else {
            if (sText.getXOffset() >= m_xOffset) {
                sText.setXOffset(sText.getXOffset() - m_xOffset);
            } else {
                sText.setXOffset(0);
            }
            if (sText.getYOffset() >= m_yOffset) {
                sText.setYOffset(sText.getYOffset() - m_yOffset);
            } else {
                sText.setYOffset(0);
            }
        }
    }

    public void setXOffset(int xOffset) {
        m_xOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        m_yOffset = yOffset;
    }

    public void setName(String text) {
        updateText(text);
        updatePreferredSize();
        setSize(getPreferredSize());
    }

    public void setForeground(Color fgColor) {
        super.setForeground(fgColor);
        StyledText stx = getStyledText();
        stx.setRunColor(0, fgColor);
    }

    public String toString() {
        return getName();
    }

    public Dimension getPreferredSize() {
        if (m_updateSize) {
            updatePreferredSize();
        }

        if (null == m_preferredSize) {
            return getSize();
        }

        return m_preferredSize;
    }

    public void addNotify() {
        super.addNotify();
        // System.out.println("addNotify for label: " + getName());
        if (null == m_preferredSize) {
            m_updateSize = true;
        }
    }

    private void updatePreferredSize() {
        Graphics g = getGraphics();

        if (null != g) {
            Dimension size = getSize();
            StyledText sText = getStyledText();
            m_preferredSize = sText.getPreferredSize(
                                                     g,
                                                     size.width,
                                                     size.height);
            m_updateSize = false;
        }
    }

    public Dimension getMinimumSize() {
        return getSize();
    }

    public void forceUpdateSize() {
        m_updateSize = true;
    }

}// GenericLabel
