/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.rebop;

/**
 * Partial implementation of the GenericDrawable interface so
 * derived classes don't have to implement the Offset methods.
 * @author Gavin Doughtie
 */
public abstract class AbstractDrawable implements GenericDrawable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/AbstractDrawable.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    // These offsets control how far the GenericDrawable
    // will be drawn past the passed-in x and y
    private int m_xOffset = 0;
    private int m_yOffset = 0;

    public void setXOffset(int xOffset) {
        m_xOffset = xOffset;
    }

    public int getXOffset() {
        return m_xOffset;
    }

    public int getYOffset() {
        return m_yOffset;
    }

    public void setYOffset(int yOffset) {
        m_yOffset = yOffset;
    }

}// AbstractDrawable
