/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.jsp;


import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

/**
 * Sets up a data query for use in a page.
 *
 * <p>Usage:</p>
 *
 * <pre><code>&lt;acs:master path="path/to/master.jsp" />
 **/
public class QueryTag extends BodyTagSupport {

    private String name = null;

    public QueryTag() {

        super();
    }

    public void setName(String name) {

        this.name = name;
    }

    public int doStartTag() throws JspTagException {

        Session session = SessionManager.getSession();
        DataQuery dataQuery = session.retrieveQuery(name);
        pageContext.setAttribute("dataQuery", dataQuery);

        return EVAL_BODY_TAG;
    }

    public void release() {

        this.name = null;
    }
}
