/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import javax.servlet.http.HttpServletRequest;

/**
 *  This is an interface that allows developers to set variables
 *  that will be available inside of the XSL for use by all XSL stylesheets.
 *  Implementations of this class can be registered with the 
 *  {@link com.arsdigita.templating.Templating}
 *  class for use by any {@link com.arsdigita.templating.PresentationManager}
 *  class
 */
public interface XSLParameterGenerator {
    
    /**
     *  This returns the correct value for the parameter.  This is the
     *  value that is added to the transformer and is available to all
     *  stylesheets 
     */
    public String generateValue(HttpServletRequest request);
}
