/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.xml.Document;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Interface for styling and serving XML documents to
 * the response output stream. The PresentationManager contains the
 * code that determines which XSLT transformer(s) are to be applied to
 * a given document. The default
 * BasePresentationManager should suffice for most cases. A custom
 * presentation manager is needed if an application needs to
 * dynamically apply a set of templates to an XML document in a custom
 * way. Typically, this occurs if the template selection
 * depends on the outcome of some application-specific logic.
 *
 * @author Bill Schneider
 * @version ACS 4.6
 * @see com.arsdigita.sitenode.SiteNodePresentationManager
 * @see com.arsdigita.sitenode.BasePresentationManager
 */
public interface PresentationManager {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/templating/PresentationManager.java#10 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    /**
     * Serves a page whose content is defined by the input XML
     * document.  Gets an appropriate XSLT Transformer object and
     * uses the transformer to convert the DOM input to the final
     * output.
     *
     * @param doc the XML document whose content is to be displayed
     * to the output
     * @param req the servlet request
     * @param resp the servlet response
     */
    public void servePage(Document doc,
                          HttpServletRequest req,
                          HttpServletResponse resp);

    // WRS: I really would like to be able to define
    // "public static getInstance()" here to make the singleton pattern
    // enforced at compile time, but Java doesn't allow that declaration
    // in an interface or abstract class.
}
