/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating;

import com.arsdigita.dispatcher.DispatcherHelper;
import javax.servlet.http.HttpServletRequest;

/**
 * Generates a pattern for based on the request prefix,
 * eg /print/content/myitem.jsp     -> { 'print' }
 *    /text-only/content/myitem.jsp -> { 'text-only' }
 */
public class PrefixPatternGenerator implements PatternGenerator {
    public String[] generateValues(String key,
                                   HttpServletRequest req) {
        String value = DispatcherHelper.getDispatcherPrefix(req);
        if (value != null) {
            return new String[] { value.substring(1) };
        }
        
        return new String[] { };
    }
}
