/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.ui.StaticFilterComponent;
import com.arsdigita.search.filters.ObjectTypeFilterSpecification;
import com.arsdigita.bebop.PageState;

/**
 * A simple filter generator that restricts to a 
 * specified set of object types
 */
public class ObjectTypeFilterComponent extends StaticFilterComponent {

    private String[] m_types;
    
    /**
     * Creates a filter generator restricting to a single
     * object type
     * 
     * @param type the object type name
     */
    public ObjectTypeFilterComponent(String type) {
        this(new String[] {type});
    }

    /**
     * Creates a filter generator restricting to a single
     * object type
     *
     * @param types the list of object type names
     */
    public ObjectTypeFilterComponent(String[] types) {
        m_types = types;
    }

    
    public FilterSpecification getFilter(PageState state) {
        return new ObjectTypeFilterSpecification(
            m_types
        );
    }

}
