/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.ui.filters;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.search.filters.CategoryFilterSpecification;
import com.arsdigita.search.filters.CategoryFilterType;

import com.arsdigita.categorization.Category;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.xml.Element;


/**
 * A base component for presenting a list of categories 
 * for filtering. This class needs to be subclassed to
 * implement the method for generating the list of 
 * categories
 */
public abstract class CategoryFilterWidget extends FilterWidget {
    
    /**
     * Creates a new category filter component
     */
    public CategoryFilterWidget() {
        super(new CategoryFilterType(),
              new ArrayParameter(new OIDParameter(CategoryFilterType.KEY)));
    }

    public FilterSpecification getFilter(PageState state) {
        OID[] oids = (OID[])getValue(state);
        if (oids == null) {
            oids = new OID[0];
        }

        Category[] cats = new Category[oids.length];
        for (int i = 0 ; i < cats.length ; i++) {
            cats[i] = (Category)DomainObjectFactory.newInstance(oids[i]);
        }

        return new CategoryFilterSpecification(cats);
    }
    
    
    /**
     * Returns a list of categories to display for 
     * selection
     */
    public abstract Category[] getCategories(PageState state);

    public void generateBodyXML(PageState state,
                                Element parent) {
        super.generateBodyXML(state, parent);

        OID[] oids = (OID[])getValue(state);
        Category[] cats = getCategories(state);

        for (int i = 0 ; i < cats.length ; i++) {
            Element type = Search.newElement("category");
            type.addAttribute("oid", cats[i].getOID().toString());
            type.addAttribute("title", cats[i].getName());
            type.addAttribute("description", cats[i].getDescription());
            if (oids != null) {
                for (int j = 0 ; j < oids.length ; j++) {
                    if (oids[j].equals(cats[i].getOID())) {
                        type.addAttribute("isSelected", "1");
                        break;
                    }
                }
            }
            parent.addContent(type);
        }
    }
}
