/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import java.io.IOException;
import java.util.BitSet;

import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;

/**
 *
 * TypeSpecificFilter
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @version $Id: //core-platform/dev/src/com/arsdigita/search/lucene/TypeSpecificFilter.java#3 $
 *
 **/

public class TypeSpecificFilter extends Filter {

    private final static Logger s_log =
        Logger.getLogger(TypeSpecificFilter.class);

    private String m_typeSpecificInfo;

    /**
     * Creates a new lucene <code>Filter</code> that filters search results
     * based on whether the "type-specific field" matches the terms supplied in
     * the <code>typeSpecificInfo</code> argument.
     *
     * @param typeSpecificInfo the object type to filter on
     *
     **/
    public TypeSpecificFilter(String typeSpecificInfo) {
        m_typeSpecificInfo = typeSpecificInfo;
    }

    /**
     * Returns a <code>BitSet</code> with <code>true</code> for documents which
     * should be permitted in search results, and <code>false</code> for those
     * that should not.
     **/
    public final BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermDocs enum = reader.termDocs(new Term(Document.TYPE_SPECIFIC_INFO,
                                                 m_typeSpecificInfo));

        while (enum.next()) {
            bits.set(enum.doc());
        }

        return bits;
    }

}
