/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;

import java.util.Map;
import java.util.HashMap;


/**
 * Registry
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

public class Registry {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/lucene/Registry.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Registry REGISTRY = new Registry();

    public static final Registry getInstance() {
        return REGISTRY;
    }

    private Map m_adapters = new HashMap();

    // Will change to private when compatability pacage is removed
    protected Registry() {}

    public boolean hasAdapter(ObjectType type) {
        return getAdapter(type) != null;
    }

    public Adapter getAdapter(ObjectType type) {
        Adapter result = (Adapter) m_adapters.get(type.getQualifiedName());

        if (result == null && type.getSupertype() != null) {
            result = getAdapter(type.getSupertype());
        }

        return result;
    }

    public void addAdapter(ObjectType type, Adapter adapter) {
        m_adapters.put(type.getQualifiedName(), adapter);
    }

    public void addAdapter(String type, Adapter adapter) {
        addAdapter(MetadataRoot.getMetadataRoot().getObjectType(type),
                   adapter);
    }

}
