/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.GenericDataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import java.math.BigDecimal;

/**
 *
 *
 *
 * @author Joseph A. Bank (jbank@alum.mit.edu)
 * @version 1.0
 **/
public class SearchDataQuery extends GenericDataQuery {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SearchDataQuery.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String OBJECT_TYPE = "object_type";
    public static final String OBJECT_ID = "object_id";
    public static final String SUMMARY = "summary";
    public static final String LINK_TEXT = "link_text";
    public static final String URL_STUB = "url_stub";
    public static final String SCORE = "score";

    public SearchDataQuery(Session s, String sql, String[] columns) {
        super(s, sql, columns);
    }

    /**
     * Return the OID of the result
     */
    public OID getOID() {
        return new OID(getObjectType(), getID());
    }

    public String getObjectType() {
        return (String)get(OBJECT_TYPE);
    }

    public BigDecimal getID() {
        return (BigDecimal)get(OBJECT_ID);
    }

    public String getSummary() {
        return (String)get(SUMMARY);
    }

    public String getLinkText() {
        return (String)get(LINK_TEXT);
    }

    public String getUrlStub() {
        return (String)get(URL_STUB);
    }

    public BigDecimal getScore() {
        return (BigDecimal)get(SCORE);
    }

    // XXX: I'm removing this temporarily. See comment in
    //      SimpleSearchSpecificaiton.java rhs@mit.edu

    /*    void dobind(String name, Object value) {
          super.bind(name, value);
          } */
}
