/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.filters;

import com.arsdigita.search.FilterSpecification;
import com.arsdigita.categorization.Category;


/**
 * A filter specification for supplying a list of categories
 * to the category membership filter type
 */
public class CategoryFilterSpecification extends FilterSpecification {
    
    public static final String CATEGORIES = "categories";

    /**
     * Creates a new category filter spec
     * @param cats the categories to check membership of
     */
    public CategoryFilterSpecification(Category[] cats) {
        super(new Object[] { CATEGORIES, cats },
              new CategoryFilterType());
    }
    
    /**
     * Returns the list of categories to check
     * @return the list of categories
     */
    public Category[] getCategories() {
        return (Category[])get(CATEGORIES);
    }
}
