/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.domain.DomainObject;

/**
 * This interface is implemented by a search indexer
 * to recieve notification of updates to documents that
 * are searchable. It is invoked during the beforeCommit
 * event of a transaction.
 *
 * This interface is not intended to be used by applications.
 * A search indexer will register an implementation of this
 * class using the SearchConfig#registerIndexer method.
 */
public interface DocumentObserver {
    
    /**
     * Invoked after a searchable object has been 
     * created or updated.
     *
     * @param dobj the updated object
     */
    void onSave(DomainObject dobj);

    /**
     * Invoked after a searchable object has been 
     * deleted. NB, the only guarenteed valid method
     * that can be invoked on the DomainObject is
     * getOID().
     *
     * @param dobj the deleted object
     */
    void onDelete(DomainObject dobj);
}
