/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.Assert;
import com.arsdigita.util.config.JavaPropertyLoader;
import java.io.InputStream;
import org.apache.log4j.Logger;

/**
 * @deprecated Use {@link AbstractConfig#load()} instead.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/RuntimeConfigLoader.java#5 $
 */
public class RuntimeConfigLoader extends JavaPropertyLoader {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/runtime/RuntimeConfigLoader.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (RuntimeConfigLoader.class);

    private final RuntimeClassLoader m_loader;

    public RuntimeConfigLoader() {
        super(System.getProperties());

        m_loader = new RuntimeClassLoader
            (Thread.currentThread().getContextClassLoader());
    }

    public RuntimeConfigLoader(final String resource, final boolean required) {
        this();
        load(resource, required);
    }

    public final void load(final String resource, final boolean required) {
        Assert.exists(resource, String.class);

        final InputStream in = m_loader.getResourceAsStream(resource);

        if (in == null) {
            if (required) {
                throw new ConfigError
                    ("Resource " + resource + " not found; it is required");
            } else {
                if (s_log.isInfoEnabled()) {
                    s_log.info(resource + " was not found; proceeding anyhow");
                }
            }
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug("Loading configuration values from " +
                            resource + " on the class path");
            }

            load(in);
        }
    }
}
