/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.domain.DomainObjectFactory;

/**
 * A DomainInitEvent is passed to the {@link
 * Initializer#init(DomainInitEvent)} to provide access to the
 * necessary objects required to initialize the domain layer.
 *
 * @author Rafael Schloming &lt;rhs@mit.edu&gt;
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/DomainInitEvent.java#5 $
 */
public final class DomainInitEvent {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/runtime/DomainInitEvent.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final DomainObjectFactory m_factory;

    DomainInitEvent(final DomainObjectFactory factory) {
        m_factory = factory;
    }

    /**
     * Returns a DomainObjectFactory object that should be used to
     * register domain object instantiators.
     *
     * @return a DomainObjectFactory
     **/

    public final DomainObjectFactory getFactory() {
        return m_factory;
    }

}
