/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal.apportlet;

import com.arsdigita.portal.PortletType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;
import java.math.BigDecimal;


/**
 *
 * @author <a href="mailto:jparsons@redhat.com">Jim Parsons</a>
 */
public final class AppPortletType extends PortletType {

    private static final Logger s_cat =
        Logger.getLogger(AppPortletType.class.getName());

    private final static String IS_PORTAL_APPLICATION =
        "isWorkspaceApplication";

    protected AppPortletType(DataObject dataObject) {
        super(dataObject);
    }

    // Create from packageType.
    protected AppPortletType
        (String dataObjectType, String title, String profile,
         String portletObjectType) {
        super(dataObjectType,title,profile,portletObjectType);

    }


    public static AppPortletType retrieveAppPortletType(BigDecimal id) {
        Assert.assertNotNull(id, "id");

        return AppPortletType.retrieveAppPortletType
            (new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public static AppPortletType retrieveAppPortletType(OID oid) {
        Assert.assertNotNull(oid, "oid");

        DataObject dataObject = SessionManager.getSession().retrieve(oid);

        Assert.assertNotNull(dataObject);

        return AppPortletType.retrieveAppPortletType(dataObject);
    }

    public static AppPortletType retrieveAppPortletType(DataObject dataObject) {
        Assert.assertNotNull(dataObject, "dataObject");

        return new AppPortletType(dataObject);
    }

    public static AppPortletType retrieveAppPortletTypeForAppPortlet
        (String portletObjectType) {
        Assert.assertNotNull(portletObjectType, "portletObjectType");

        DataCollection collection =
            SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);

        Assert.assertNotNull(collection, "collection");

        collection.addEqualsFilter("objectType", portletObjectType);

        AppPortletType portletType = null;

        if (collection.next()) {
            portletType = AppPortletType.retrieveAppPortletType
                (collection.getDataObject());
        } else {
            s_cat.warn("No portlet type found that matches \"" +
                       portletObjectType + ".\"  Check that the portlet " +
                       "type is registered in the system.");
        }

        collection.close();
        return portletType;
    }

    public static AppPortletType createAppPortletType
        (String title, String profile, String portletObjectType) {
        return new AppPortletType
            (BASE_DATA_OBJECT_TYPE, title, profile, portletObjectType);
    }


    public void setPortalApplication(boolean isPortalApplication) {
        set(IS_PORTAL_APPLICATION, new Boolean(isPortalApplication));
    }

    public boolean isPortalApplication() {
        Boolean isPortalApplication =
            (Boolean) get(IS_PORTAL_APPLICATION);

        Assert.assertNotNull(isPortalApplication, IS_PORTAL_APPLICATION);

        return isPortalApplication.booleanValue();
    }

}
