/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal;

import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.util.Assert;

/**
 * 
 *
 * <p>Describes a set of portlet domain objects.</p>
 *
 * @see Portlet
 * @see Portal
 * @see DefaultPortalModel
 * @author Justin Ross
 * @author James Parsons
 * @version $Id: //core-platform/dev/src/com/arsdigita/portal/PortletCollection.java#7 $
 */
public class PortletCollection extends ApplicationCollection {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/PortletCollection.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public PortletCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Get the current item as a Portlet domain object.
     *
     * @return a Portlet domain object.
     * @post return != null
     */
    public Portlet getPortlet() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Portlet portlet = Portlet.retrievePortlet(dataObject);

        Assert.assertNotNull(portlet);

        return portlet;
    }
}
