/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.portal.PortletRenderer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.PortletType;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

/**
 *
 * <p>
 * This Portlet class is used for creating portlets to be rendered
 * in a sub portal.
 * @author Jim Parsons
 */
public class AgentPortlet extends Portlet {

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.portal.AgentPortlet";
    private static Logger s_log = Logger.getLogger(AgentPortlet.class);

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public AgentPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public AgentPortlet(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static AgentPortlet 
              createAgentPortlet(Portlet p, Resource parent, Portal portal) {
        PortletType ptype = 
             PortletType.retrievePortletTypeForPortlet(BASE_DATA_OBJECT_TYPE);
        Assert.assertNotNull(ptype, "PortletType");
        AgentPortlet aportlet = (AgentPortlet) Resource.createResource
                      (ptype, p.getTitle(), parent);
        aportlet.setCellNumber(p.getCellNumber());
        aportlet.setSortKey(p.getSortKey());
        aportlet.setPortal(portal);
        aportlet.setSuperPortlet(p);
        return aportlet;
 
    }


    //
    // Association properties
    //

    // To make this role accessible to the Portal domain object.
    public void setSuperPortlet(final Portlet portlet) {
        Assert.assertNotNull(portlet);

        setAssociation("superportlet", portlet);

    }

    // Cannot return null.
    public Portlet getSuperPortlet() {
        DataObject dataObject = (DataObject)get("superportlet");

        Portlet portlet = Portlet.retrievePortlet(dataObject);

        Assert.assertNotNull(portlet);

        return portlet;
    }


    //
    // Portlet rendering methods
    //

    public PortletRenderer getPortletRenderer() {
        Portlet p = getSuperPortlet();
        AbstractPortletRenderer portletRenderer = p.doGetPortletRenderer();

        portletRenderer.setTitle(getTitle());
        portletRenderer.setCellNumber(getCellNumber());
        portletRenderer.setSortKey(getSortKey());
        portletRenderer.setProfile(getProfile());

        return portletRenderer;
    }

}
