/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.apps;

import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public interface PopulateApp {
    
    /**
     * Sets the BaseStringSeed to use in populating data
     * @param sSeed the seed value to use for generating String data in population
     */
    public void setBaseStringSeed(String sSeed);
    
    /**
     * Gets the BaseStringSeed used in populating data
     * @return the BaseStringSeed used in populating data
     */
    public String getBaseStringSeed();
    
    /**
     * Create the application with title, sTitle and parent Application, parent
     * @param sTitle the title of the new app to create and populate
     * @param parent the parent application or null if there is none
     */
    public void createApp(String sTitle, Application parent);        
    
    /**
     * Populates the created app using the arguments in args.
     * This method runs in its own transaction
     * @param args the arguments to use in populating the app
     */
    public void populateApp(java.util.List args);        
    
    
    /**
     * Returns a description of the arguments for populating this application
     * @return description of the args to PopulateApp()
     */
    public String getArgsDescription();
    
    /**
     * Returns the app instance created for populating data
     */
    public Application getApp();
    
    /**
     * Returns the application type of the app we are creating and populating
     * @return the Application type we are creating and populating
     */
    public ApplicationType getAppType();
    
    /**
     * Returns a new portlet for the populated application, if appropriate.  Otherwise returns null.
     * @return a new portlet for the populated application, if appropriate.  Otherwise returns null.
     */
    public AppPortlet getPortlet();
}
