/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.util.parameter.*;
import com.arsdigita.util.*;

import java.io.*;
import java.util.*;

import org.apache.commons.cli.*;

/**
 * Set
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

class Set extends Command {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Set.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Options OPTIONS = getOptions();

    static {
        OPTIONS.addOption
            (OptionBuilder
             .hasArg(false)
             .withLongOpt("interactive")
             .withDescription("Interactively edit configuration values")
             .create());
    }

    public Set() {
        super("set", "Set one or more values in a CCM configuration database");
    }

    public boolean run(String[] args) {
        CommandLine line;
        try {
            line = new PosixParser().parse(OPTIONS, args);
        } catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }

        if (args.length == 0) {
            usage(OPTIONS, System.err, "[KEY=VALUE...]");
            return false;
        }

        if (line.hasOption("usage") || line.hasOption("help")) {
            usage(OPTIONS, System.out, "[KEY=VALUE...]");
            return true;
        }

        ConfigRegistry reg = new ConfigRegistry();
        Config config = new Config(reg);
        config.load(System.err);

        Properties props = Load.props(line.getArgs());

        boolean valid = true;
        for (Iterator it = props.keySet().iterator(); it.hasNext(); ) {
            String param = (String) it.next();
            if (config.getParameter(param) == null) {
                System.out.println("no such parameter: " + param);
                valid = false;
            }
        }

        if (!valid) { return false; }

        if (!config.load(new JavaPropertyReader(props), System.err)) {
            return false;
        }

        if (line.hasOption("interactive")) {
            ParameterEditor editor = new ParameterEditor
                (config, System.in, System.out);
            if (!editor.edit()) {
                return true;
            }
        } else if (!config.validate(System.err)) {
            return false;
        }

        try {
            config.save();
        } catch (IOException e) {
            System.err.println(e.getMessage());
            return false;
        }

        return true;
    }

}
