/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.util.*;

import java.io.*;
import java.util.*;

/**
 * Menu
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

class Menu {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Menu.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    static final class Layout {
        private Layout() {}
    }

    public static final Layout VERTICAL = new Layout();
    public static final Layout HORIZONTAL = new Layout();

    static interface Item {

        String getDescription();

        void act();

    }

    public static final Item GAP = new Item() {
        public String getDescription() {
            return null;
        }
        public void act() {}
    };


    private List m_entries;
    private Map m_keys;
    private BufferedReader m_in;
    private PrintStream m_out;
    private int m_padd;

    public Menu(BufferedReader in, PrintStream out) {
        m_entries = new ArrayList();
        m_keys = new HashMap();
        m_in = in;
        m_out = out;
        m_padd = 0;
    }

    public void add(Item item) {
        add(null, item);
    }

    public void add(String key, Item item) {
        add(key, item, VERTICAL);
    }

    public void add(String key, Item item, Layout layout) {
        Entry entry = new Entry(key, item, layout);
        m_entries.add(entry);
        if (key != null) {
            m_keys.put(key, entry);
            int length = key.length();
            if (length > m_padd) {
                m_padd = length;
            }
        }
    }

    public void display() {
        boolean first = true;
        int column = 0;

        for (Iterator it = m_entries.iterator(); it.hasNext(); ) {
            Entry entry = (Entry) it.next();
            Item item = entry.getItem();
            String key = entry.getKey();
            Layout layout = entry.getLayout();

            StringBuffer buf = new StringBuffer();

            if (key != null) {
                for (int i = 0; i < m_padd + 2 - key.length(); i++) {
                    buf.append(" ");
                }
                buf.append("[" + key + "]");
            }

            String description = item.getDescription();
            if (description != null) {
                buf.append(" " + description);
            }

            if ((!first && layout == VERTICAL)
                || column + buf.length() > 79) {
                m_out.println();
                column = 0;
            }

            m_out.print(buf.toString());
            column += buf.length();
            if (first) { first = false; }
        }

        m_out.println();
    }

    public Item choose(String prompt) {
        while (true) {
            m_out.print(prompt);
            m_out.flush();
            String line;
            try {
                line = m_in.readLine();
            } catch (IOException e) {
                throw new UncheckedWrapperException(e);
            }
            if (line == null) { return null; }
            line = line.trim();
            if (line.equals("")) { continue; }
            Entry entry = (Entry) m_keys.get(line);
            if (entry == null) {
                m_out.println("  * no such item: " + line);
            } else {
                return entry.getItem();
            }
        }
    }

    private class Entry {

        private String m_key;
        private Item m_item;
        private Layout m_layout;

        public Entry(String key, Item item, Layout layout) {
            m_key = key;
            m_item = item;
            m_layout = layout;
        }

        public String getKey() {
            return m_key;
        }

        public Item getItem() {
            return m_item;
        }

        public Layout getLayout() {
            return m_layout;
        }

    }

}
