/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.notification;

/**
 * Signals that a method has been invoked on a notification that has
 * type restrictions.  For example, the setHeader and setSignature
 * methods can only be applied to TEXT_PLAIN messages.
 *
 * @author Ron Henderson 
 * @version $Id: //core-platform/dev/src/com/arsdigita/notification/RestrictedTypeException.java#7 $
 */

public class RestrictedTypeException extends RuntimeException {

    /**
     * Creates a new exception with a given error message.
     * @param message the error message
     */

    public RestrictedTypeException (String message) {
        super(message);
    }
}
