/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;

/**
 * This class contains a collection of MimeTypeExtensions.
 *
 * @author <a href="mailto:flattop@arsdigita.com">Jack Chung</a>
 * @version 1.0
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 */
public class MimeTypeExtensionCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/MimeTypeExtensionCollection.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     **/
    public MimeTypeExtensionCollection(DataCollection dataCollection) {
        super(dataCollection);
    }


    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     **/
    public DomainObject getDomainObject() {
        return new MimeType(m_dataCollection.getDataObject());
    }

    /**
     * Returns a <code>MimeType</code> for the current position in
     * the collection.
     *
     **/
    public MimeTypeExtension getMimeTypeExtension() {
        return (MimeTypeExtension)getDomainObject();
    }

    public MimeType getMimeType() {
        DataObject object = (DataObject)get(MimeTypeExtension.MIME_TYPE);
        if (object != null) {
            return new MimeType(object);
        } else {
            return null;
        }
    }

    public String fileExtension() {
        return (String)get(MimeTypeExtension.FILE_EXTENSION);
    }
}
