/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import com.arsdigita.util.ParameterProvider;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.KernelRequestContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * Determines the URL parameters needed for user tracking.
 *
 * @author Sameer Ajmani
 **/
public class SecurityParameterProvider implements ParameterProvider {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/SecurityParameterProvider.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(SecurityParameterProvider.class.getName());

    /**
     * Returns a copy of <code>UserContext.getModels()</code>.
     *
     * @return a copy of <code>UserContext.getModels()</code>
     **/
    public Set getModels() {
        // get parameter models
        Set models = new HashSet();
        models.addAll(UserContext.getModels());
        return models;
    }

    /**
     * Returns a copy of the given request's <code>UserContext</code>'s
     * <code>getParams()</code>.
     *
     * @return a copy of the given request's <code>UserContext</code>'s
     * <code>getParams()</code>.
     **/
    public Set getParams(HttpServletRequest req) {
        // get user and session info
        KernelRequestContext rctx =
            KernelHelper.getKernelRequestContext(req);

        // Request context can be null e.g. if called in a request listener
        if ( rctx == null ) {
            return Collections.EMPTY_SET;
        }

        UserContext uctx = rctx.getUserContext();
        // get set of parameters
        Set params = new HashSet();
        params.addAll(uctx.getParams());
        return params;
    }
}
